/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection.search;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.SingularAttribute;
import ui.entities.collection.service.HVSCEntryService;
import ui.musiccollection.search.SearchThread;

public abstract class SearchInIndexThread
extends SearchThread {
    private SingularAttribute<?, ?> field;
    private Object fieldValue;
    private boolean caseSensitive;
    private HVSCEntryService hvscEntryService;
    private HVSCEntryService.HVSCEntries state;

    public SearchInIndexThread(EntityManager em, boolean forward, Consumer<Void> searchStart, Consumer<File> searchHit, Consumer<Boolean> searchStop) {
        super(forward, searchStart, searchHit, searchStop);
        this.hvscEntryService = new HVSCEntryService(em);
    }

    @Override
    public void run() {
        this.searchStart.accept(null);
        if (this.state == null) {
            this.state = this.hvscEntryService.search(this.field, this.fieldValue, this.caseSensitive, this.fForward);
        }
        while (!this.fAborted && (this.fForward ? this.state.next() : this.state.prev())) {
            String filePath = this.state.getPath();
            List<File> file = this.getFiles(filePath);
            if (file.size() <= 0) continue;
            this.searchHit.accept(file.get(file.size() - 1));
        }
        if (!this.fAborted) {
            this.state = null;
        }
        this.searchStop.accept(this.fAborted);
    }

    public abstract List<File> getFiles(String var1);

    @Override
    public Object getSearchState() {
        return this.state;
    }

    @Override
    public void setSearchState(Object state) {
        if (state instanceof HVSCEntryService.HVSCEntries) {
            this.state = (HVSCEntryService.HVSCEntries)state;
        }
    }

    public SingularAttribute<?, ?> getField() {
        return this.field;
    }

    public void setField(SingularAttribute<?, ?> searchCriteria) {
        this.field = searchCriteria;
    }

    public Object getFieldValue() {
        return this.fieldValue;
    }

    public void setFieldValue(Object searchForValue) {
        this.fieldValue = searchForValue;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

